unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ExtCtrls;

type
  TMainForm = class(TForm)
    Memo: TMemo;
    OpenDialog: TOpenDialog;
    Panel1: TPanel;
    btnCLOSE: TBitBtn;
    btnSAVE: TBitBtn;
    btnLOAD: TBitBtn;
    btnReadChar: TBitBtn;
    btnSimpleWrite: TBitBtn;
    btnSimpleRead: TBitBtn;
    SaveDialog: TSaveDialog;
    procedure btnSimpleReadClick(Sender: TObject);
    procedure btnSimpleWriteClick(Sender: TObject);
    procedure btnReadCharClick(Sender: TObject);
    procedure btnLOADClick(Sender: TObject);
    procedure btnSAVEClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure btnCLOSEClick(Sender: TObject);

  private
	 procedure  Zapisz_w_pliku(fn : String);
	 procedure  Czytaj_z_pliku(fn : String);
	 procedure  Czytaj_z_pliku_po_znaku(fn : String);

  public

  end;

var
  MainForm: TMainForm;

implementation
{$R *.dfm}
{------------------------------------------------------------------------------}
procedure TMainForm.btnReadCharClick(Sender: TObject);
var
   fn : String;

begin
	if OpenDialog.Execute() then
   begin
      if(Application.MessageBox('Wczyta zawarto pliku do Memo?',
                                 'Uwaga', MB_YESNO) = IDYES) then
      begin
         Memo.Clear();
         fn := OpenDialog.FileName;

         Czytaj_z_pliku_po_znaku(fn);

      end;
   end;
end;

procedure TMainForm.btnCLOSEClick(Sender: TObject);
begin
	Close();
end;

procedure TMainForm.FormShow(Sender: TObject);
begin
   Memo.Clear();
   Memo.Align := alClient;
end;

procedure TMainForm.btnSAVEClick(Sender: TObject);
var
   fn : String;

begin
   Memo.Visible := false;

   if(Application.MessageBox('Zapamita stan Memo w pliku?',
                              'Uwaga', MB_YESNO) = IDNO) then
   begin
   	exit;
   end;

   if SaveDialog.Execute() then
   begin
      fn := SaveDialog.FileName;
      Zapisz_w_pliku(fn);
   end;

   Memo.Visible := true;
end;

procedure TMainForm.btnSimpleReadClick(Sender: TObject);
var
   fn : String;

begin
   Memo.Visible := false;

   if OpenDialog.Execute() then
   begin
      if(Application.MessageBox('Wczyta zawarto pliku do Memo?',
                                 'Uwaga', MB_YESNO) = IDYES) then
      begin
         Memo.Clear();
         fn := OpenDialog.FileName;

         Memo.Lines.LoadFromFile(fn);
      end;
   end;

   Memo.Visible := true;
end;

procedure TMainForm.btnSimpleWriteClick(Sender: TObject);
var
   fn : String;

begin
   Memo.Visible := false;

   if(Application.MessageBox('Zapamita stan Memo w pliku?',
                              'Uwaga', MB_YESNO) = IDNO) then
   begin
   	exit;
   end;

   if SaveDialog.Execute() then
   begin
      fn := SaveDialog.FileName;
      Memo.Lines.SaveToFile(fn);
   end;

   Memo.Visible := true;
end;

procedure TMainForm.btnLOADClick(Sender: TObject);
var
   fn : String;

begin
   Memo.Visible := false;

   if OpenDialog.Execute() then
   begin
      if(Application.MessageBox('Wczyta zawarto pliku do Memo?',
                                 'Uwaga', MB_YESNO) = IDYES) then
      begin
         Memo.Clear();
         fn := OpenDialog.FileName;

         Czytaj_z_pliku(fn);
      end;
   end;

   Memo.Visible := true;
end;

procedure TMainForm.Zapisz_w_pliku(fn : String);
var
   fh     : TextFile;
	s      : String;
   lp     : Integer;

begin
	{
	zamiast Memo.Lines.SaveToFile(fn);
	}
   if FileExists(fn) then
   begin
      DeleteFile(fn);
   end;

 	AssignFile(fh, fn);
   Rewrite(fh);

   for lp := 0 to Memo.Lines.Count-1 do
   begin
   	s := Memo.Lines[lp];
      Writeln(fh, s);
   end;
   CloseFile(fh);

   if FileExists(fn) then
   begin
      ShowMessage('Plik :' + fn + ' utworzony prawidowo');
   end;
end;

procedure TMainForm.Czytaj_z_pliku(fn : String);
var
   fh : TextFile;
   s  : String;

begin
	{
	zamiast Memo.Lines.LoadFromFile(fn);
	}
   if not FileExists(fn) then
   begin
      exit;
   end;

   AssignFile(fh, fn);
   Reset(fh);

   while not Eof(fh) do
   begin
		Readln(fh, s);
      Memo.Lines.Add(s);
   end;

   CloseFile(fh);
end;

procedure TMainForm.Czytaj_z_pliku_po_znaku(fn : String);
var
	fh   : File of Char;
   znak : Char;
   s    : String;

begin
   Memo.Visible := false;

   if not FileExists(fn) then
   begin
      exit;
   end;

   AssignFile(fh, fn);
   Reset(fh);

   while not Eof(fh) do
   begin
   	s    := '';
      znak := #0;

      // czytaj tekst do koca wiersza
      while (znak <> #13) and (not EOF(fh)) do
      begin
      	Read(fh, znak);
         s := s + znak;
      end;

      Memo.Lines.Add(s);
      Application.ProcessMessages();
   end;

   CloseFile(fh);
   Memo.Visible := true;
end;

end.
